# Perplexity Pro Automated Redemption System - PHP Backend

This is the frontend and PHP backend for the Perplexity Pro automated redemption system.

## 📁 File Structure

```
perplexity/
├── index.php                    # Main entry point
├── config.php                   # Database & Node.js configuration
├── .htaccess                    # Apache configuration
├── api/
│   ├── send-otp.php            # API: Start redemption process
│   └── verify-otp.php          # API: Verify OTP and activate
└── assets/
    ├── css/
    │   ├── style.css           # Main styles
    │   └── rtl.css             # RTL support for Arabic/Kurdish
    ├── js/
    │   ├── main.js             # Frontend logic
    │   └── translations.js     # 4-language translations
    └── images/
        └── flags/              # Flag images (optional)
```

## 🚀 Deployment Instructions

### Step 1: Database Setup

1. Log into cPanel → MySQL Databases
2. Create database: `kardonia_perplexity`
3. Create user with a **strong password**
4. Grant ALL PRIVILEGES to user on database
5. Go to phpMyAdmin
6. Import `database.sql` (located in project root)

### Step 2: Upload Files

1. Connect via FTP or use cPanel File Manager
2. Navigate to `/public_html/`
3. Upload the `perplexity/` folder
4. Final path should be: `/public_html/perplexity/`

### Step 3: Configure Settings

Edit `config.php` and update:

```php
// Database credentials
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_strong_password');

// Node.js service URL (your Oracle Cloud IP)
define('NODE_SERVICE_URL', 'http://YOUR_ORACLE_IP:3000');

// Generate strong secret with: openssl rand -hex 32
define('NODE_SECRET', 'your_random_secret_here');
```

**IMPORTANT:** The `NODE_SECRET` must match the secret in your Node.js `.env` file!

### Step 4: Set Permissions

```bash
chmod 644 *.php
chmod 644 .htaccess
chmod 755 api/
chmod 644 api/*.php
chmod 755 assets/
```

### Step 5: Test the System

1. Add a test promo code to database:
   ```sql
   INSERT INTO codes (code, uuid) VALUES ('TEST-CODE', UUID());
   SELECT CONCAT('https://kardonia.com/perplexity?uuid=', uuid) as link FROM codes WHERE code = 'TEST-CODE';
   ```

2. Visit the generated link
3. Test the complete flow

## 🔐 Security Checklist

- [ ] Changed database password to a strong one
- [ ] Generated random `NODE_SECRET` (32+ characters)
- [ ] Ensured SSL certificate is active (HTTPS)
- [ ] Verified `.htaccess` is working
- [ ] Tested that `config.php` is not accessible via browser
- [ ] Set proper file permissions

## 📊 Adding Promo Codes

To add new promo codes and generate redemption links:

```sql
-- Add codes
INSERT INTO codes (code, uuid) VALUES
('TELEKOM-XXXX-XXXX', UUID()),
('XFINITY-YYYY-YYYY', UUID());

-- Get redemption links
SELECT
    CONCAT('https://kardonia.com/perplexity?uuid=', uuid) as redemption_link,
    code,
    status,
    created_at
FROM codes
WHERE status = 'available'
ORDER BY created_at DESC;
```

## 🐛 Troubleshooting

### "Database connection failed"
- Check credentials in `config.php`
- Verify database exists in cPanel
- Ensure user has privileges

### "Service unavailable" error
- Check if Node.js service is running on Oracle Cloud
- Verify `NODE_SERVICE_URL` in config.php
- Check firewall allows connection to port 3000

### API returns 404
- Verify `.htaccess` is working
- Check file permissions
- Ensure `mod_rewrite` is enabled

### Translations not working
- Check browser console for JavaScript errors
- Verify `translations.js` is loaded
- Clear browser cache

## 📝 API Endpoints

### POST /api/send-otp.php
Start redemption process and send OTP to user's email.

**Request:**
```json
{
  "email": "user@example.com",
  "uuid": "550e8400-e29b-41d4-a716-446655440000"
}
```

**Response:**
```json
{
  "success": true,
  "sessionId": "abc123...",
  "message": "OTP sent successfully"
}
```

### POST /api/verify-otp.php
Verify OTP and activate Perplexity Pro.

**Request:**
```json
{
  "otp": "123456",
  "uuid": "550e8400-e29b-41d4-a716-446655440000"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Pro activated successfully",
  "callback_url": "https://www.perplexity.ai"
}
```

## 📱 Supported Languages

- 🇬🇧 English
- 🇨🇳 Chinese (Simplified)
- 🇸🇦 Arabic (RTL)
- 🟥⚪🟩 Kurdish Sorani (RTL)

## 📞 Support

For issues, check:
1. cPanel error logs
2. Browser console (F12)
3. Network tab in DevTools

## ⚖️ Legal Notice

Ensure you:
- Have legitimate promo codes
- Comply with Perplexity's Terms of Service
- Are transparent with customers about the service

---

**System Version:** 1.0.0
**Last Updated:** 2024
